////
//  InfiniteScrollingViewController.swift
//  InfiniteScrollingCollectionView
//
//  Created by Abhayam Rastogi on 6/19/15.
//  Copyright (c) 2015 Intelligrape. All rights reserved.
//

import UIKit

class InfiniteScrollingViewController: UIViewController {
    
    @IBOutlet weak var infiniteScrollingCollectionView: UICollectionView!
    
    private let reuseIdentifier = "InfiniteScrollingCell"
    
    private var photosUrlArray = [String]()
    
    let WINDOW_WIDTH = UIScreen.mainScreen().bounds.width
    let WINDOW_HEIGHT = UIScreen.mainScreen().bounds.height
    
    //MARK: Life Cycle Methods
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.title = "Infinite Scrolling"
        self.automaticallyAdjustsScrollViewInsets = false
        photosUrlArray = ["A_Photographer.jpg","A_Song_of_Ice_and_Fire.jpg","Another_Rockaway_Sunset.jpg","Antelope_Butte.jpg"]
        
        infiniteScrollingCollectionView?.delegate = self
        infiniteScrollingCollectionView?.dataSource = self
    }
    
    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        
        
    }
    
    
    //MARK: Private Methods
    
    func photoForIndexPath(indexPath: NSIndexPath) -> String {
        return photosUrlArray[indexPath.row]
    }
    
    
    func reversePhotoArray(photoArray:[String], startIndex:Int, endIndex:Int){
        if startIndex >= endIndex{
            return
        }
        swap(&photosUrlArray[startIndex], &photosUrlArray[endIndex])
        
        reversePhotoArray(photosUrlArray, startIndex: startIndex + 1, endIndex: endIndex - 1)
    }
    
}


//*********************************************************************************************************************

//MARK: UICollection View Methods
//*********************************************************************************************************************

extension InfiniteScrollingViewController : UICollectionViewDataSource{
    func numberOfSectionsInCollectionView(collectionView: UICollectionView) -> Int {
        return 1
    }
    
    func collectionView(collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return photosUrlArray.count
    }
    
    func collectionView(collectionView: UICollectionView, cellForItemAtIndexPath indexPath: NSIndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCellWithReuseIdentifier(reuseIdentifier, forIndexPath: indexPath) as! InfiniteScrollingCell
        let photoName = photoForIndexPath(indexPath)
        
        cell.configureCell(photoName)
        
        return cell
    }
}


extension InfiniteScrollingViewController : UICollectionViewDelegateFlowLayout {
    
    func collectionView(collectionView: UICollectionView,
        layout collectionViewLayout: UICollectionViewLayout,
        sizeForItemAtIndexPath indexPath: NSIndexPath) -> CGSize {
            
            let size:CGSize = CGSizeMake(WINDOW_WIDTH, (WINDOW_WIDTH)*1.203460)
            return size
            
    }
    
    func collectionView(collectionView: UICollectionView,
        layout collectionViewLayout: UICollectionViewLayout,
        insetForSectionAtIndex section: Int) -> UIEdgeInsets {
            return UIEdgeInsetsMake(0, 0, 0, 0)
    }
}




extension InfiniteScrollingViewController:UIScrollViewDelegate{
    
    func scrollViewDidEndDecelerating(scrollView: UIScrollView) {
        // Calculate where the collection view should be at the right-hand end item
        let fullyScrolledContentOffset:CGFloat = infiniteScrollingCollectionView.frame.size.width * CGFloat(photosUrlArray.count - 1)
        if (scrollView.contentOffset.x >= fullyScrolledContentOffset) {
            
            // user is scrolling to the right from the last item to the 'fake' item 1.
            // reposition offset to show the 'real' item 1 at the left-hand end of the collection view
            if photosUrlArray.count>2{
                reversePhotoArray(photosUrlArray, startIndex: 0, endIndex: photosUrlArray.count - 1)
                reversePhotoArray(photosUrlArray, startIndex: 0, endIndex: 1)
                reversePhotoArray(photosUrlArray, startIndex: 2, endIndex: photosUrlArray.count - 1)
                var indexPath : NSIndexPath = NSIndexPath(forRow: 1, inSection: 0)
                infiniteScrollingCollectionView.scrollToItemAtIndexPath(indexPath, atScrollPosition: .Left, animated: false)
            }
        }
        else if (scrollView.contentOffset.x == 0){
            
            if photosUrlArray.count>2{
                reversePhotoArray(photosUrlArray, startIndex: 0, endIndex: photosUrlArray.count - 1)
                reversePhotoArray(photosUrlArray, startIndex: 0, endIndex: photosUrlArray.count - 3)
                reversePhotoArray(photosUrlArray, startIndex: photosUrlArray.count - 2, endIndex: photosUrlArray.count - 1)
                var indexPath : NSIndexPath = NSIndexPath(forRow: photosUrlArray.count - 2, inSection: 0)
                infiniteScrollingCollectionView.scrollToItemAtIndexPath(indexPath, atScrollPosition: .Left, animated: false)
            }
        }
    }
}



